# Function-Space Variational Inference for Deep Bayesian Classification
Our code uses Python 3 and the 'torch', 'torchvision', 'numpy', 'matplotlib', 'sklearn' and 'tqdm' libraries.

Individual files:
- 'datasets.py' implements the Corrupted CIFAR10 and Corrupted CIFAR100 data set
- 'models.py' and 'resnet.py' implement all MLP and CNN models for ML and fVI training, and quasi-Newton Dirichlet precision estimation
- 'two_moons.py' implements toy problem classification (Figure 3)
- 'mnist_train.py', 'cifar10_train.py' and 'cifar100_train.py' implement scripts to train models
- 'mnist_config.py', 'cifar10_config.py' and 'cifar100_config.py' implement configurations used by the training script
- 'evaluation.py' implements accuracy, log-likelihood, expected calibration error, closed-form mutual information and the FGSM attack
- 'mnist_alphas.py', 'cifar10_alphas.py' and 'cifar100_alphas.py' implement scripts to evaluate the trained models on regular and corrupted test sets.
- 'cifar10_adversarial.py' and 'cifar100_adversarial.py' implement the adversarial attack experiment

The scripts are written without argparse. To select a specific model and compute device, the script must be edited slightly. To create the individual plots from the Two Moons toy experiment (Figure 3), you need to (un)comment the corresponding model for which the experiment should be run in the 'two_moons.py' file. 

Data:
- MNIST requires data files to be in ./data/MNIST/ (automatically downloaded by PyTorch)
- CIFAR10 requires data files to be in ./data/cifar-10-batches-py/ (automatically downloaded by PyTorch)
- CIFAR100 requires data files to be in ./data/cifar-100-python/ (automatically downloaded by PyTorch)
- Corrupted CIFAR10 requires the .npy files to be in ./data/CIFAR-10-C/ (see https://github.com/hendrycks/robustness for the download link)
- Corrupted CIFAR100 requires the .npy files to be in ./data/CIFAR-100-C/ (see https://github.com/hendrycks/robustness for the download link)
