import models
import torch.nn as nn


mlp_map = dict(
    model=models.MLPMAPClassifier,
    kwargs=dict(
        hidden_dims=(50, 50),
        bias=True,
        activation=nn.ReLU
    ),
    n_batch=256,
    epochs=30,
    lr=0.001
)

mlp_map_fvi = dict(
    model=models.MLPMAPFVIClassifier,
    kwargs=dict(
        hidden_dims=(50, 50),
        bias=True,
        activation=nn.ReLU
    ),
    n_batch=256,
    epochs=30,
    lr=0.001
)

mlp_dropout = dict(
    model=models.MLPDropoutClassifier,
    kwargs=dict(
        hidden_dims=(50, 50),
        bias=True,
        activation=nn.ReLU,
        dropout=0.2
    ),
    n_batch=256,
    epochs=30,
    lr=0.001
)

mlp_dropout_fvi = dict(
    model=models.MLPDropoutFVIClassifier,
    kwargs=dict(
        hidden_dims=(50, 50),
        bias=True,
        activation=nn.ReLU,
        dropout=0.2
    ),
    n_batch=256,
    epochs=30,
    lr=0.001
)

mlp_ensemble = dict(
    model=models.MLPEnsembleClassifier,
    kwargs=dict(
        hidden_dims=(50, 50),
        bias=True,
        activation=nn.ReLU,
        n_models=10,
    ),
    n_batch=256,
    epochs=30,
    lr=0.001
)

mlp_ensemble_fvi = dict(
    model=models.MLPEnsembleFVIClassifier,
    kwargs=dict(
        hidden_dims=(50, 50),
        bias=True,
        activation=nn.ReLU,
        n_models=10,
    ),
    n_batch=256,
    epochs=30,
    lr=0.001
)
