import models
from resnet import BasicBlock, DropoutBasicBlock, RadialBasicBlock, Rank1BasicBlock


cnn_map = dict(
    model=models.CNNMAPClassifier,
    kwargs=dict(
        block=BasicBlock,
        n_blocks=[2, 2, 2, 2],
    ),
    n_batch=128,
    epochs=200,
    lr=0.01,
    momentum=.9,
    weight_decay=0.0005,
    milestones=[100, 150],
    gamma=.1
)

cnn_map_fvi = dict(
    model=models.CNNMAPFVIClassifier,
    kwargs=dict(
        block=BasicBlock,
        n_blocks=[2, 2, 2, 2],
    ),
    n_batch=128,
    epochs=200,
    lr=0.01,
    momentum=.9,
    weight_decay=0.,
    milestones=[100, 150],
    gamma=.1
)

cnn_dropout = dict(
    model=models.CNNDropoutClassifier,
    kwargs=dict(
        block=DropoutBasicBlock,
        n_blocks=[2, 2, 2, 2],
        dropout=0.2
    ),
    n_batch=128,
    epochs=200,
    lr=0.01,
    momentum=.9,
    weight_decay=0.0005,
    milestones=[100, 150],
    gamma=.1
)

cnn_dropout_fvi = dict(
    model=models.CNNDropoutFVIClassifier,
    kwargs=dict(
        block=DropoutBasicBlock,
        n_blocks=[2, 2, 2, 2],
        dropout=0.1
    ),
    n_batch=128,
    epochs=200,
    lr=0.01,
    momentum=.9,
    weight_decay=0.,
    milestones=[100, 150],
    gamma=.1
)

cnn_ensemble = dict(
    model=models.CNNEnsembleClassifier,
    kwargs=dict(
        block=BasicBlock,
        n_blocks=[2, 2, 2, 2],
        n_models=5
    ),
    n_batch=128,
    epochs=200,
    lr=0.01,
    momentum=.9,
    weight_decay=0.0005,
    milestones=[100, 150],
    gamma=.1
)

cnn_ensemble_fvi = dict(
    model=models.CNNEnsembleFVIClassifier,
    kwargs=dict(
        block=BasicBlock,
        n_blocks=[2, 2, 2, 2],
        n_models=5
    ),
    n_batch=128,
    epochs=200,
    lr=0.01,
    momentum=.9,
    weight_decay=0.,
    milestones=[100, 150],
    gamma=.1
)

cnn_radial = dict(
    model=models.CNNRadialClassifier,
    kwargs=dict(
        block=RadialBasicBlock,
        n_blocks=[2, 2, 2, 2],
    ),
    n_batch=128,
    epochs=200,
    lr=0.01,
    momentum=.9,
    weight_decay=0.,
    milestones=[100, 150],
    gamma=.1
)

cnn_radial_fvi = dict(
    model=models.CNNRadialFVIClassifier,
    kwargs=dict(
        block=RadialBasicBlock,
        n_blocks=[2, 2, 2, 2],
    ),
    n_batch=128,
    epochs=200,
    lr=0.01,
    momentum=.9,
    weight_decay=0.,
    milestones=[100, 150],
    gamma=.1
)

cnn_rank1 = dict(
    model=models.CNNRank1Classifier,
    kwargs=dict(
        block=Rank1BasicBlock,
        n_blocks=[2, 2, 2, 2],
        n_models=4
    ),
    n_batch=128,
    epochs=250,
    lr=0.01,
    momentum=.9,
    weight_decay=0.,
    milestones=[150, 200],
    gamma=.1
)

cnn_rank1_fvi = dict(
    model=models.CNNRank1FVIClassifier,
    kwargs=dict(
        block=Rank1BasicBlock,
        n_blocks=[2, 2, 2, 2],
        n_models=4
    ),
    n_batch=128,
    epochs=250,
    lr=0.01,
    momentum=.9,
    weight_decay=0.,
    milestones=[150, 200],
    gamma=.1
)
