#include <iostream>
#include <cstdio>
#include <algorithm>
#include <vector>
#include <cmath>
#include <cstring>
#include <cstdlib>
#include <ctime>
using namespace std;

const int maxN = 50; // number of agents
const int maxM = 50; // number of edges
const int MAX_BATCH_SIZE = 35;

class Tree_Solver
{

    int n, m;
    vector<pair<double, pair<int, int> > > Edge;
    int fa[maxN];

    int find(int x)
    {
        return fa[x] == x ? x : fa[x] = find(fa[x]);
    }

public:
    void solve(double *py_g, double *best_graph, int py_n)
    {
        n = py_n;
        Edge.clear();
        for (int i = 0; i < n; i++)
            for (int j = 0; j < n; j++)
                Edge.push_back(make_pair(py_g[i * py_n + j], make_pair(i, j)));
        m = Edge.size();
        sort(Edge.begin(), Edge.end());
        for (int i = 1; i <= n; i++)
            fa[i] = i;
        for (int i = m - 1; i >= 0; i--)
        {
            int u = Edge[i].second.first + 1, v = Edge[i].second.second + 1;
            if (find(u) != find(v))
            {
                best_graph[(u - 1) * n + v - 1] = best_graph[(v - 1) * n + u - 1] = 1;
                fa[find(u)] = find(v);
            }
        }
    }
};

Tree_Solver tree_solver[MAX_BATCH_SIZE];

extern "C" void
maximum_spanning_tree(double *py_g, double *best_graph, int py_bs, int py_n)
{
#pragma omp parallel for schedule(dynamic, 1) num_threads(MAX_BATCH_SIZE)
    for (int i = 0; i < py_bs; i++)
        tree_solver[i].solve(py_g + i * py_n * py_n, best_graph + i * py_n * py_n, py_n);
}
