import numpy as np
import gurobipy as gp
from gurobipy import GRB

def solve_LP(c, A_temp, b_temp, G, h):
    decision_num = c.shape[0]
    rowSizeA = A_temp.shape[0]
    sizeA = A_temp.size
    if rowSizeA > 0 and sizeA == rowSizeA:
        A = np.zeros((1, decision_num))
        A[0] = A_temp
        b = np.zeros(1)
        b[0] = b_temp
    else:
        A = A_temp
        b = b_temp
#    print(A, b)
    rowSizeA = A.shape[0]
    rowSizeG = G.shape[0]
    c = c.tolist()
    A = A.tolist()
    b = b.tolist()
    G = G.tolist()
    h = h.tolist()
#    print(c, A, b, G, h)
    
#    decision_num = np.size(c)
    m = gp.Model()
    m.setParam('OutputFlag', 0)
    x = m.addVars(decision_num, vtype=GRB.CONTINUOUS, name='x')

    OBJ = x.prod(c)
    m.setObjective(OBJ, GRB.MINIMIZE)
    for i in range(rowSizeA):
        m.addConstr(x.prod(A[i]) == b[i])
    for j in range(rowSizeG):
        m.addConstr(x.prod(G[j]) <= h[j])

    m.optimize()
    sol = np.zeros(decision_num)
#    print(objective)
    try:
#        objective = m.OBJ
#        print("Gurobi c: ", c)
        for i in range(decision_num):
            sol[i] = x[i].x
#        print(sol)
    except:
#        print("cannot solve")
        m.computeIIS()
        m.write('model.ilp')
        np.savetxt('c.txt', c, fmt="%.2f")
        np.savetxt('A.txt', A, fmt="%.2f")
        np.savetxt('b.txt', b, fmt="%.2f")
        np.savetxt('G.txt', G, fmt="%.2f")
        np.savetxt('h.txt', h, fmt="%.2f")
#        input("Continue?")

    return sol
    
    
def solve_IP(c, A_temp, b_temp, G, h):
    decision_num = c.shape[0]
    rowSizeA = A_temp.shape[0]
    sizeA = A_temp.size
    if rowSizeA > 0 and sizeA == rowSizeA:
        A = np.zeros((1, decision_num))
        A[0] = A_temp
        b = np.zeros(1)
        b[0] = b_temp
    else:
        A = A_temp
        b = b_temp
#    print(A, b)
    rowSizeA = A.shape[0]
    rowSizeG = G.shape[0]
    c = c.tolist()
    A = A.tolist()
    b = b.tolist()
    G = G.tolist()
    h = h.tolist()
#    print(c, A, b, G, h)
    
#    decision_num = np.size(c)
    m = gp.Model()
    m.setParam('OutputFlag', 0)
    x = m.addVars(decision_num, vtype=GRB.INTEGER, name='x')

    OBJ = x.prod(c)
    m.setObjective(OBJ, GRB.MINIMIZE)
    for i in range(rowSizeA):
        m.addConstr(x.prod(A[i]) == b[i])
    for j in range(rowSizeG):
        m.addConstr(x.prod(G[j]) <= h[j])

    m.optimize()
    sol = np.zeros(decision_num)
#    print(objective)
    try:
#        objective = m.OBJ
#        print("Gurobi c: ", c)
        for i in range(decision_num):
            sol[i] = x[i].x
#        print(sol)
    except:
        print("cannot solve")
        input("Continue?")
        m.computeIIS()
        m.write('model.ilp')
        np.savetxt('c.txt', c, fmt="%.2f")
        np.savetxt('A.txt', A, fmt="%.2f")
        np.savetxt('b.txt', b, fmt="%.2f")
        np.savetxt('G.txt', G, fmt="%.2f")
        np.savetxt('h.txt', h, fmt="%.2f")
#        input("Continue?")

    return sol


def get_lp_obj(c, A_temp, b_temp, G, h):
    decision_num = c.shape[0]
    rowSizeA = A_temp.shape[0]
    sizeA = A_temp.size
    if rowSizeA > 0 and sizeA == rowSizeA:
        A = np.zeros((1, decision_num))
        A[0] = A_temp
        b = np.zeros(1)
        b[0] = b_temp
    else:
        A = A_temp
        b = b_temp
#    print(A, b)
    rowSizeA = A.shape[0]
    rowSizeG = G.shape[0]
    c = c.tolist()
    A = A.tolist()
    b = b.tolist()
    G = G.tolist()
    h = h.tolist()
#    print(c, A, b, G, h)
    
#    decision_num = np.size(c)
    m = gp.Model()
    m.setParam('OutputFlag', 0)
    x = m.addVars(decision_num, vtype=GRB.CONTINUOUS, name='x')

    OBJ = x.prod(c)
    m.setObjective(OBJ, GRB.MINIMIZE)
    for i in range(rowSizeA):
        m.addConstr(x.prod(A[i]) == b[i])
    for j in range(rowSizeG):
        m.addConstr(x.prod(G[j]) <= h[j])

    m.optimize()
    sol = np.zeros(decision_num)
    objective = 0
#    print(objective)
    try:
        objective = m.OBJVal
#        objective = m.getObjective()
#        print("LP: ", objective.getValue(), end=" sol: ")
#        for i in range(decision_num):
#            sol[i] = x[i].x
#            print(sol[i], end=", ")
#        print()
    except:
        print("cannot solve")
        m.computeIIS()
        m.write('model.ilp')
        np.savetxt('c.txt', c, fmt="%.2f")
        np.savetxt('A.txt', A, fmt="%.2f")
        np.savetxt('b.txt', b, fmt="%.2f")
        np.savetxt('G.txt', G, fmt="%.2f")
        np.savetxt('h.txt', h, fmt="%.2f")
        input("Continue?")

    return objective

#c = np.loadtxt("c.txt")
#A = np.loadtxt("A.txt")
#b = np.loadtxt("b.txt")
#G = np.loadtxt("G.txt")
#h = np.loadtxt("h.txt")
#sol = solve_LP(c,A,b,G,h)
#print(sol)

