
# Verifiably Robust Conformal Prediction

The code we provide is split into two distinct packages, one for classification and the other for regression, and have been developed independently. In both cases, we provide instructions on how to first configure your Python environment and then instructions on how to perform the same experiments in the paper.

We are grateful to the authors of the various packages on which our method extends, and acknowledge the authors in the section that follows.

# Acknowledgements

For classification, we make use of the original [RSCP](https://github.com/Asafgendler/RSCP) (Gendler et al.) and [RSCP+](https://github.com/Trustworthy-ML-Lab/Provably-Robust-Conformal-Prediction) (Yan et al.) libraries to benchmark our method and provide the foundation for our classification experiments.

In regression, we make use of the [nonconformist](https://github.com/donlnz/nonconformist) library by Henrik Linusson as well as the [Conformalized Quantile Regression (CQR)](https://github.com/yromano/cqr) code developed by Yaniv Roman et al. For the RL-related libraries, we package the `tianshou` and `PettingZoo` libraries with minor modifications to allow for overriding the default environments to our prediction task.

 The libraries `mpe_helper` and `vrcp_config` have been developed by Tom Kuipers.

# Licenses

We release the code for our VRCP methods under the MIT license.

All aforementioned libraries are distributed and subject to the MIT license with the exception of auto_LiRPA whose license can be found [here](https://raw.githubusercontent.com/Verified-Intelligence/auto_LiRPA/master/LICENSE)
