# MATTAR: Multi-Agent Policy Transfer via Task Relationship Modeling

This is the repo for the paper "MATTAR: Multi-Agent Policy Transfer via Task Relationship Modeling".

## Installation instructions

Set up StarCraft II and SMAC:

```shell
bash install_sc2.sh
```

This will download SC2 into the 3rdparty folder and copy the maps necessary to run over. You may also need to set the SC2 environment variabale:

```bash
export SC2PATH=[Your SC2 folder like /abc/xyz/3rdparty/StarCraftII]
```

Install Python environment with conda:

```bash
conda create -n pymarl python=3.7 -y
conda activate pymarl
conda install pytorch torchvision torchaudio cudatoolkit=10.2 -c pytorch -y
pip install sacred numpy scipy matplotlib seaborn pyyaml pygame pytest probscale imageio snakeviz tensorboard-logger tensorboard tensorboardx sympy
```

## Add new maps

We provide the SMAC maps needed in our paper with `new_maps.zip`. Please unzip it, add them to map dir path under `SC2PATH`, and modify the map configs in installed SMAC (in `smac_maps.py` file).

## Run an experiment 

Run MATTAR for single-task learning:

```shell
python3 src/main.py --config=sota_beta --env-config=[Env name] with env_args.map_name=[Map name]
```

Run MATTAR for multi-task training:

```shell
python3 src/main.py --config=xtrans_train_beta --task-config=[Task name]
```

Now supported task names are `marine_battle`, `stalkers_and_zealots` and `MMM`. The config about training tasks are set in config files under `./src/config/tasks`. If you want to add new setting about multi-task training, please add new config files under this path.

Run MATTAR for few_shot transfer:

```shell
python3 src/main.py --config=xmeta_test_beta --task-config=[Task name] --map_name=[Map name] --transfer_training=False --few_shot_adaptation=True --checkpoint_path=[checkpoint_path] --load_repre_dir=[load_repre_dir] --sparse_loss_coef=[sparse_loss_coef]
```

Here, `checkpoint_path` is the dir path of loaded model, `load_repre_dir` is the dir path of saved task representations for source tasks and `sparse_loss_coef` is the coefficient of entropy regularization loss term (hyperparameter $\lambda$ in our paper).