REGISTRY = {}

# normal learner
from .q_learner import QLearner
from .coma_learner import COMALearner
from .qtran_learner import QLearner as QTranLearner
from .dc_learner import DCLearner
from .trans_learner import TransLearner
from .xtrans_learner import XTransLearner

REGISTRY["q_learner"] = QLearner
REGISTRY["coma_learner"] = COMALearner
REGISTRY["qtran_learner"] = QTranLearner
REGISTRY["dc_learner"] = DCLearner
REGISTRY["trans_learner"] = TransLearner
REGISTRY["xtrans_learner"] = XTransLearner


# some multi-task learner
from .multi_task import TransLearner as MultiTaskTransLearner
from .multi_task import XTransLearner as MultiTaskXTransLearner
from .multi_task import NRXTransLearner as MultiTaskNRXTransLearner

REGISTRY["mt_trans_learner"] = MultiTaskTransLearner
REGISTRY["mt_xtrans_learner"] = MultiTaskXTransLearner
REGISTRY["mt_nrxtrans_learner"] = MultiTaskNRXTransLearner