# Asynchronous value factorization (AVF)

AVF implements value factorization in the asynchronous multi-agent reinforcement learning setting using macro-actions. This code provides the baselines for AVF algorithms built upon the popular VDN, QMIX, QPLEX algorithms.

The user must set up [wandb](https://wandb.ai/home) to run and log the results of the experiments.

## Installation

1. Download [Miniconda](https://docs.anaconda.com/free/miniconda/) for your system.
2. Install Miniconda
3. Go to the asynchronous_vf main folder
    ```bash
    cd asynchronous_vf
    ```
# Install any missing dependencies using 'pip'
3. Set-Up conda environment:
    ```bash
    conda env create -f conda_env.yml
    ```
4. Activate the conda environment
    ```bash
    conda activate asynchronous_vf
    ```
4. Set-Up asynchronous_vf:
    ```bash
    pip install .
    ```

## Usage

Run the *main.py* with the desired set of parameters and task configuration. There are several parameters useful to log the results of a training run (see *main.py* argument parser as well as the algorithm-specific parameters under *algorithms/<algorithm>/config.py*. Please, set up the configuration files properly to reproduce our experiments.