from common.imports import *
from common.utils import str2bool

def get_alg_args() -> Namespace:
    parser = ap.ArgumentParser()

    # vdn, qmix, qplex
    parser.add_argument("--mixer", type=str, default='qmix', help="Factorization method to use")
    parser.add_argument("--detach", type=int, default=2, help="Whether to update all the agents (0), detach ongoing agent gradients (1) or zero ongoing agent qvalues (2), or both (3)")
    parser.add_argument("--extra-info", type=int, default=0, help="Whether to use the state as extra mixer info (0), the macro state (1), a vector of zeros (2) or a vector of ones (3)")
    parser.add_argument("--reward-scheme", type=int, default=1, help="Whether to use the joint reward of all agents (0), or the joint reward of terminated agents (1)")

    parser.add_argument("--gamma", type=float, default=.9, help="Discount factor")
    parser.add_argument("--tau", type=float, default=1.0, help="Target network update rate")
    parser.add_argument("--eps-start", type=float, default=1.0, help="Starting epsilon for exploration")
    parser.add_argument("--eps-end", type=float, default=0.05, help="Final epsilon for exploration")
    parser.add_argument("--eps-decay-frac", type=float, default=0.6, help="Fraction of total-timesteps required to reach eps-end")
    parser.add_argument("--buffer-size", type=int, default=1000, help="Max number of episodes/sequences to store")  
    parser.add_argument("--batch-size", type=int, default=32, help="Batch size of memory sample")
    parser.add_argument("--seq-len", type=int, default=25, help="Size of the lookup for random sample")

    parser.add_argument("--lr", type=float, default=2.5e-4, help="Learning rate for the Q-network")   # 0.01
    parser.add_argument('--hysteretic', type=str2bool, default=True, 
        help='Whether to use hysteretic lr decay or not')
    parser.add_argument('--hyst-start', type=float, default=0.2, help='Initial value of hysteretic learning rate')  #0.2
    parser.add_argument('--hyst-end', type=float, default=1.0,  help='Final value of hysteretic learning rate') #0.4
    parser.add_argument('--hyst-frac', type=float, default=0.4, help="Fraction of `tot-episodes` to anneal hysteretic")
    parser.add_argument('--train-freq', type=int, default=10, help='Training frequency in timesteps')
    parser.add_argument('--tg-qnet-freq', type=int, default=200, help='Timesteps required to update the target network')

    parser.add_argument('--h-size', type=int, default=32, help='Hidden layer size')
    parser.add_argument('--act-fn', type=str, default='tanh', help='Activation function')
    parser.add_argument("--dueling", type=str2bool, default=False, help="Whether to use dueling architecture")

    parser.add_argument("--norm-obs", type=str2bool, default=False, help="Whether to norm obs")
    parser.add_argument("--norm-rew", type=str2bool, default=False, help="Whether to norm rew")

    return parser.parse_known_args()[0]
