from gymnasium.envs.registration import registry, register

if 'BP-v0' not in registry.keys():
    register(
        id='BP-v0',
        entry_point='macro_torch_rl.environments.tasks.box_pushing:BoxPushing',
    )

    register(
        id='BP-MA-v0',
        entry_point='macro_torch_rl.environments.tasks.box_pushing_MA:BoxPushing_harder',
    )

    register(
        id='OSD-S-v4',
        entry_point='macro_torch_rl.environments.tasks.osd_ma_single_room:ObjSearchDelivery_v4',
    )

    register(
        id='OSD-D-v7',
        entry_point='macro_torch_rl.environments.tasks.osd_ma_double_room:ObjSearchDelivery_v7',
    )

    register(
        id='OSD-T-v0',
        entry_point='macro_torch_rl.environments.tasks.osd_ma_tripple_room:ObjSearchDelivery_v0',
    )

    register(
        id='OSD-T-v1',
        entry_point='macro_torch_rl.environments.tasks.osd_ma_tripple_room:ObjSearchDelivery_v1',
    )

    register(
        id='OSD-F-v0',
        entry_point='macro_torch_rl.environments.tasks.osd_ma_four_room:ObjSearchDelivery_v0',
    )

    register(
        id='CT-v0',
        entry_point='macro_torch_rl.environments.tasks.capture_target:CaptureTarget',
    )

    register(
        id='CT-MA-v0',
        entry_point='macro_torch_rl.environments.tasks.capture_target_MA:CaptureTarget_MA_v1',
    )