import sys

import gymnasium as gym
from gymnasium.vector import AsyncVectorEnv
from gymnasium.vector.utils import write_to_shared_memory, iterate

def make_env(args, idx, norm_obs=False, norm_rew=False):
    def thunk():
        env = gym.make(args.env_id, **vars(args))  
        if norm_obs: env = gym.wrappers.NormalizeObservation(env)
        if norm_rew: env = gym.wrappers.NormalizeReward(env)
        env.reset(seed=args.seed+idx)
        return env
    return thunk

def get_boxpushing_params(args):
    return {
        'grid_dim': [args.grid_size, args.grid_size],
        'big_box_reward': 300.,     # 300
        'small_box_reward': 20.,    # 20
        'penalty': -10.,    # -10
        'terminate_step': 100,
    }

def get_capturetarget_params(args):
    return {
        'n_target': 1,
        'n_agent': 10,
        'grid_dim': [args.grid_size, args.grid_size],
        'terminate_step': 100
    }

def get_osd_params(args):
    env_id = args.env_id
    if env_id == 'OSD-S-v4':
        return {
            'human_speed_per_step': [[18, 18, 18, 18]],
            'terminate_step': 150
        }
    if env_id == 'OSD-D-v7':
        return {
            'human_speed_per_step': [[27, 20, 20, 20], [27, 20, 20, 20]],
            'terminate_step': 200
        }
    if env_id == 'OSD-T-v0':
        return {
            'human_speed_per_step': [[40, 40, 40, 40], [40, 40, 40, 40], [40, 40, 40, 40]],
            'terminate_step': 250
        }
    if env_id == 'OSD-T-v1':
        return {
            'human_speed_per_step': [[38, 38, 38, 38], [38, 38, 38, 38], [27, 27, 27, 27]],
            'terminate_step': 250
        }
    if env_id == 'OSD-F-v0':
        return {
            'human_speed_per_step': [[40, 40, 40, 40], [40, 40, 40, 40], [40, 40, 40, 40], [40, 40, 40, 40]],
            'terminate_step': 300
        }
