%game 1
A1 = [0.5 0.4; 0.2 0.3];
B1 = [0.7 0.3; 0.6 0.5];

T = 3*100000;
K = 2;
Sample = 1;

mu10_sn = [0 0]; %prior mean for player 1 Case 1
mu20_sn = [0 0]; %prior mean for player 2 Case 2

mu10_gn = [0.2 0.6]; %prior mean for player 1 Case 1
mu20_gn = [0.4 0.5]; %prior mean for player 2 Case 2

[x1_sn_1,x2_sn_1,phi1_sn_1,psi1_sn_1] = game(A1,B1,T,K,Sample,mu10_sn,mu20_sn);
[x1_gn_1,x2_gn_1,phi1_gn_1,psi1_gn_1] = game(A1,B1,T,K,Sample,mu10_gn,mu20_gn);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
figure(1)
x0=100;
y0=100;
width=650;
height=500;
set(gcf,'position',[x0,y0,width,height])
plot(1:1:T,reshape(phi1_sn_1(1,1:T),[1,T]),'color','#0072BD','LineWidth',1.2)
hold on
plot(1:1:T,reshape(psi1_sn_1(1,1:T),[1,T]),'color','#77AC30','LineWidth',1.2)
hold on
plot(1:1:T,reshape(phi1_gn_1(1,1:T),[1,T]),'--','color','#EDB120','LineWidth',1.2)
hold on
plot(1:1:T,reshape(psi1_gn_1(1,1:T),[1,T]),'--','color','#FF0000','LineWidth',1.2)
hold on
ax = gca;
ax.FontSize = 16; 
set(gca, 'XScale', 'log')
xlim([1,T])
xticks([1 100 10000 T])
xticklabels({'1','10^2','10^4','3\times10^5'})
ylim([0 1.2])
x=xlabel('Time','FontSize', 16);
y=ylabel('Probability','FontSize', 16);
legend('Player 1 Case 1','Player 2 Case 1','Player 1 Case 2','Player 2 Case 2','FontSize', 14,'Location','southeast');
set(x,'Interpreter','latex');
set(y,'Interpreter','latex');
set(legend,'Interpreter','latex');
% print(gcf,'-dpng','arm1_prob_1.png')
