%game4
%2*3 game
A4 = [0.6 0.4 0.1; 0.2 0.5 0.3; 0.8 0.7 0.4];
B4 = [0.4 0.6 0; 0.3 0.3 0.6; 0.5 0.6 0.4];

T = 500000;
Sample = 1;

m = size(A4,1);
n = size(A4,2);
mu10_sn = [0 0 0]; %prior mean for player 1 Case 1 standard normal
mu20_sn = [0 0 0]; %prior mean for player 2 Case 1 standard normal

[x1_sn_2,x2_sn_2,phi1_sn_2,psi1_sn_2,f1_sn_2,f2_sn_2] = game4(A4,B4,T,m,n,Sample,mu10_sn,mu20_sn);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
figure(4)
x0=100;
y0=100;
width=650;
height=500;
set(gcf,'position',[x0,y0,width,height])
plot(1:1:T,reshape(phi1_sn_2(1,3,1:T),[1,T]),'color','#EDB120','LineWidth',1.2)
hold on
plot(1:1:T,reshape(psi1_sn_2(1,2,1:T),[1,T]),'--','color','#0072BD','LineWidth',1.2)
hold on
ax = gca;
ax.FontSize = 16; 
set(gca, 'XScale', 'log')
xlim([1,T])
xticks([1 100 10000 T])
xticklabels({'1','10^2','10^4','5\times10^5'})
ylim([0 1.2])
x=xlabel('Time','FontSize', 16);
y=ylabel('Probability','FontSize', 16);
legend('Player 1 Action 3','Player 2 Action 2','FontSize', 14,'Location','southeast');
set(x,'Interpreter','latex');
set(y,'Interpreter','latex');
set(legend,'Interpreter','latex');
% print(gcf,'-dpng','optimalarm_prob_multiple.png')
