function [mu1,mu2,Phi,Psi] = game(A,B,T,K,Sample,mu10,mu20)
    I1 = zeros(Sample,T);
    I2 = zeros(Sample,T);
    R1 = zeros(Sample,T); 
    R2 = zeros(Sample,T);
    
    mu1 = zeros(Sample,K,T); %posterior mean for player 1
    mu2 = zeros(Sample,K,T); %posterior mean for player 2
    w = zeros(Sample,K,T); %posterior variance for player 1
    v = zeros(Sample,K,T); %posterior variance for player 2
    theta1 = zeros(Sample, K, T); 
    theta2 = zeros(Sample, K, T); 
    N1 = zeros(Sample,K,T); %arm selected times for player 1
    N2 = zeros(Sample,K,T); %arm selected times for player 2
    f1 = zeros(Sample,K,T); %arm selected frequency for player 1
    f2 = zeros(Sample,K,T); %arm selected frequency for player 2
    
    Iner1 = zeros(Sample,T); 
    Iner2 = zeros(Sample,T); 
    Phi = zeros(Sample,T); %phi1
    Psi = zeros(Sample,T); %psi1
    
    for s =1:Sample 
        disp(s)
        theta1(s,1,1) = normrnd(mu10(1),1);
        theta1(s,2,1) = normrnd(mu10(2),1);
        theta2(s,1,1) = normrnd(mu20(1),1);
        theta2(s,2,1) = normrnd(mu20(2),1);
        [~, I1(s,1)] = max(theta1(s,:,1));
        [~, I2(s,1)] = max(theta2(s,:,1));
        R1(s,1) = normrnd(A(I1(s,1),I2(s,1)),1);
        R2(s,1) = normrnd(B(I1(s,1),I2(s,1)),1);
             
        t = 1;
        for i=1:K
            N1(s,i,t) = (I1(s,t)==i);
            N2(s,i,t) = (I2(s,t)==i);
            mu1(s,i,t) = (mu10(i)+R1(s,t)*(I1(s,t)==i))/(N1(s,i,t)+1);
            mu2(s,i,t) = (mu20(i)+R2(s,t)*(I2(s,t)==i))/(N2(s,i,t)+1);
            w(s,i,t) = 1/(N1(s,i,t)+1);
            v(s,i,t) = 1/(N2(s,i,t)+1);
            f1(s,i,t) = N1(s,i,t)/t;
            f2(s,i,t) = N2(s,i,t)/t;
        end
    
        Iner1(s,t) = (mu1(s,1,t)-mu1(s,2,t))/sqrt(w(s,1,t)+w(s,2,t)); 
        Iner2(s,t) = (mu2(s,1,t)-mu2(s,2,t))/sqrt(v(s,1,t)+v(s,2,t));
        Phi(s,t) = normcdf(Iner1(s,t));
        Psi(s,t) = normcdf(Iner2(s,t));
    
        for t = 2:T
            for i= 1:K
                theta1(s,i,t) = normrnd(mu1(s,i,t-1),sqrt(w(s,i,t-1)));                     
                theta2(s,i,t) = normrnd(mu2(s,i,t-1),sqrt(v(s,i,t-1)));                                      
            end
            [~, I1(s,t)] = max(theta1(s,:,t));
            [~, I2(s,t)] = max(theta2(s,:,t));
                    
            R1(s,t) = normrnd(A(I1(s,t),I2(s,t)),1);
            R2(s,t) = normrnd(B(I1(s,t),I2(s,t)),1);
    
            for i = 1:K
                N1(s,i,t) = N1(s,i,t-1)+(I1(s,t)==i);
                N2(s,i,t) = N2(s,i,t-1)+(I2(s,t)==i);
                    
                mu1(s,i,t) = (mu1(s,i,t-1)*(N1(s,i,t-1)+1)+R1(s,t)*(I1(s,t)==i))/(N1(s,i,t)+1);
                mu2(s,i,t) = (mu2(s,i,t-1)*(N2(s,i,t-1)+1)+R2(s,t)*(I2(s,t)==i))/(N2(s,i,t)+1);
                
                w(s,i,t) = 1/(N1(s,i,t)+1);
                v(s,i,t) = 1/(N2(s,i,t)+1);
                
                f1(s,i,t) = N1(s,i,t)/t;
                f2(s,i,t) = N2(s,i,t)/t;
            end
            
            Iner1(s,t) = (mu1(s,1,t)-mu1(s,2,t))/sqrt(w(s,1,t)+w(s,2,t)); 
            Iner2(s,t) = (mu2(s,1,t)-mu2(s,2,t))/sqrt(v(s,1,t)+v(s,2,t));
            Phi(s,t) = normcdf(Iner1(s,t));
            Psi(s,t) = normcdf(Iner2(s,t));
        end
    end
end
