function [mu1,mu2,Phi,Psi,f1,f2] = game4(A,B,T,m,n,Sample,mu10,mu20)
    I1 = zeros(Sample,T);
    I2 = zeros(Sample,T);
    R1 = zeros(Sample,T); 
    R2 = zeros(Sample,T);
    
    mu1 = zeros(Sample,m,T); %posterior mean for player 1
    mu2 = zeros(Sample,n,T); %posterior mean for player 2
    w = zeros(Sample,m,T); %posterior variance for player 1
    v = zeros(Sample,n,T); %posterior variance for player 2
    theta1 = zeros(Sample, m, T); 
    theta2 = zeros(Sample, n, T); 
    N1 = zeros(Sample,m,T); %arm selected times for player 1
    N2 = zeros(Sample,n,T); %arm selected times for player 2
    f1 = zeros(Sample,m,T); %arm selected frequency for player 1
    f2 = zeros(Sample,n,T); %arm selected frequency for player 2

    Phi = zeros(Sample,m,T); %phi1
    Psi = zeros(Sample,n,T); %psi1
    
    for s =1:Sample 
        disp(s)
        t = 1;
        for i=1:m
            theta1(s,i,t) = normrnd(mu10(i),1);     
        end

        for j=1:n
            theta2(s,j,t) = normrnd(mu20(j),1);  
        end          
        [~, I1(s,t)] = max(theta1(s,:,t));
        [~, I2(s,t)] = max(theta2(s,:,t));
        R1(s,t) = normrnd(A(I1(s,t),I2(s,t)),1);
        R2(s,t) = normrnd(B(I1(s,t),I2(s,t)),1);

        for i=1:m
            N1(s,i,t) = (I1(s,t)==i);        
            mu1(s,i,t) = (mu10(i)+R1(s,t)*(I1(s,t)==i))/(N1(s,i,t)+1);          
            w(s,i,t) = 1/(N1(s,i,t)+1);
            f1(s,i,t) = N1(s,i,t)/t;
        end
        
        for j = 1:n
            N2(s,j,t) = (I2(s,t)==j);
            mu2(s,j,t) = (mu20(j)+R2(s,t)*(I2(s,t)==j))/(N2(s,j,t)+1);
            v(s,j,t) = 1/(N2(s,j,t)+1);
            f2(s,j,t) = N2(s,j,t)/t;
        end

        Phi(s,1,t) = normcdf((mu1(s,1,t)-mu1(s,2,t))/sqrt(w(s,1,t)+w(s,2,t)))*normcdf((mu1(s,1,t)-mu1(s,3,t))/sqrt(w(s,1,t)+w(s,3,t)));
        Phi(s,2,t) = normcdf((mu1(s,2,t)-mu1(s,1,t))/sqrt(w(s,2,t)+w(s,1,t)))*normcdf((mu1(s,2,t)-mu1(s,3,t))/sqrt(w(s,2,t)+w(s,3,t)));
        Phi(s,3,t) = normcdf((mu1(s,3,t)-mu1(s,1,t))/sqrt(w(s,3,t)+w(s,1,t)))*normcdf((mu1(s,3,t)-mu1(s,2,t))/sqrt(w(s,3,t)+w(s,2,t)));
        Psi(s,1,t) = normcdf((mu2(s,1,t)-mu2(s,2,t))/sqrt(v(s,1,t)+v(s,2,t)))*normcdf((mu2(s,1,t)-mu2(s,3,t))/sqrt(v(s,1,t)+v(s,3,t)));
        Psi(s,2,t) = normcdf((mu2(s,2,t)-mu2(s,1,t))/sqrt(v(s,2,t)+v(s,1,t)))*normcdf((mu2(s,2,t)-mu2(s,3,t))/sqrt(v(s,2,t)+v(s,3,t)));
        Psi(s,3,t) = normcdf((mu2(s,3,t)-mu2(s,1,t))/sqrt(v(s,3,t)+v(s,1,t)))*normcdf((mu2(s,3,t)-mu2(s,2,t))/sqrt(v(s,3,t)+v(s,2,t)));

        for t = 2:T     
            for i= 1:m
                theta1(s,i,t) = normrnd(mu1(s,i,t-1),sqrt(w(s,i,t-1)));                                                       
            end
            for j= 1:n
                theta2(s,j,t) = normrnd(mu2(s,j,t-1),sqrt(v(s,j,t-1))); 
            end
            [~, I1(s,t)] = max(theta1(s,:,t));
            [~, I2(s,t)] = max(theta2(s,:,t));
     
            R1(s,t) = normrnd(A(I1(s,t),I2(s,t)),1);
            R2(s,t) = normrnd(B(I1(s,t),I2(s,t)),1);
    
            for i = 1:m
                N1(s,i,t) = N1(s,i,t-1)+(I1(s,t)==i); 
                mu1(s,i,t) = (mu1(s,i,t-1)*(N1(s,i,t-1)+1)+R1(s,t)*(I1(s,t)==i))/(N1(s,i,t)+1);   
                w(s,i,t) = 1/(N1(s,i,t)+1);
                f1(s,i,t) = N1(s,i,t)/t;           
            end

            for j = 1:n
                N2(s,j,t) = N2(s,j,t-1)+(I2(s,t)==j);
                mu2(s,j,t) = (mu2(s,j,t-1)*(N2(s,j,t-1)+1)+R2(s,t)*(I2(s,t)==j))/(N2(s,j,t)+1);    
                v(s,j,t) = 1/(N2(s,j,t)+1);
                f2(s,j,t) = N2(s,j,t)/t;
            end
        
            Phi(s,1,t) = normcdf((mu1(s,1,t)-mu1(s,2,t))/sqrt(w(s,1,t)+w(s,2,t)))*normcdf((mu1(s,1,t)-mu1(s,3,t))/sqrt(w(s,1,t)+w(s,3,t)));
            Phi(s,2,t) = normcdf((mu1(s,2,t)-mu1(s,1,t))/sqrt(w(s,2,t)+w(s,1,t)))*normcdf((mu1(s,2,t)-mu1(s,3,t))/sqrt(w(s,2,t)+w(s,3,t)));
            Phi(s,3,t) = normcdf((mu1(s,3,t)-mu1(s,1,t))/sqrt(w(s,3,t)+w(s,1,t)))*normcdf((mu1(s,3,t)-mu1(s,2,t))/sqrt(w(s,3,t)+w(s,2,t)));
            Psi(s,1,t) = normcdf((mu2(s,1,t)-mu2(s,2,t))/sqrt(v(s,1,t)+v(s,2,t)))*normcdf((mu2(s,1,t)-mu2(s,3,t))/sqrt(v(s,1,t)+v(s,3,t)));
            Psi(s,2,t) = normcdf((mu2(s,2,t)-mu2(s,1,t))/sqrt(v(s,2,t)+v(s,1,t)))*normcdf((mu2(s,2,t)-mu2(s,3,t))/sqrt(v(s,2,t)+v(s,3,t)));
            Psi(s,3,t) = normcdf((mu2(s,3,t)-mu2(s,1,t))/sqrt(v(s,3,t)+v(s,1,t)))*normcdf((mu2(s,3,t)-mu2(s,2,t))/sqrt(v(s,3,t)+v(s,2,t)));
        end
    end
end
