
import argparse

parser = argparse.ArgumentParser()

parser.add_argument('--seed', default=None, type=int,
                    help='random seed (default: None, i.e., not fix the randomness).')
parser.add_argument('--num_samples', default=3000, type=int,
                    help='num_samples.')
parser.add_argument('--batch_size', default=50, type=int,
                    help='batch_size.')
parser.add_argument('--target_size', default=256, type=int,
                    help='target_size.')
parser.add_argument('--image_path',
                    default='ILSVRC2012_images_val',
                    type=str, help='path of an image, or a directory like this image_path/*.JPEG')
parser.add_argument('--num_classes', default=1000, type=int,
                    help='num_classes.')

parser.add_argument('--model_mapping_file', default=None,
                    type=str, help='a file saving the model name and the trained model file path.')
parser.add_argument('--model_index', default=None,
                    type=int, help='an index to locate the model in the model_mapping_file.')

parser.add_argument('--model_structure', default='ResNet50_vc',
                    type=str, help='model structure')
parser.add_argument('--trained_model', default='pre_models/ResNet50_vc_pretrained',
                    type=str, help='trained_model')

parser.add_argument('--outdir',
                    default='tmp',
                    type=str, help='outdir')
parser.add_argument('--suffix',
                    default='num-models-100_s3000',
                    type=str, help='suffix that file pattern satisfies.')

parser.add_argument('--start', default=None, type=int,
                    help='start index for computing.')
parser.add_argument('--end', default=None, type=int,
                    help='end index for computing.')

args = parser.parse_args()


