import json

def find_missing(kotlin_json_path: str, kotlin_test_jsonl_path: str):
    # Load question_ids from kotlin.json
    with open(kotlin_json_path, 'r', encoding='utf-8') as f:
        kotlin_data = json.load(f)
    kotlin_ids = set(str(qid) for qid in kotlin_data.keys())

    # Load question_ids from kotlin-test.jsonl
    test_ids = set()
    with open(kotlin_test_jsonl_path, 'r', encoding='utf-8') as f:
        for line in f:
            if line.strip():
                entry = json.loads(line)
                test_ids.add(str(entry.get("question_id")))

    # Compute and print any IDs present in test but missing in kotlin
    missing = sorted(test_ids - kotlin_ids, key=int)
    if missing:
        print("Missing in kotlin.json but present in kotlin-test.jsonl:")
        for qid in missing:
            print(qid)
    else:
        print("All test entries have corresponding questions in kotlin.json.")

if __name__ == "__main__":
    find_missing("/ssd/ssd_backup/home/wuweijie/CodeJudge/evaluation/data/leetcode/dataset/kotlin.json", "/ssd/ssd_backup/home/wuweijie/CodeJudge/evaluation/data/leetcode/test_cases/kotlin-test.jsonl")