# **SFedPO: Streaming Federated Learning with a Prediction Oracle under Temporal Shifts**
The implementation of "SFedPO: Streaming Federated Learning with a Prediction Oracle under Temporal Shifts".

- [Environment](#Environment)
- [Commands](#Commands)

## Environment

```bash
nvidia-smi	# NVIDIA A40
nvcc -V 	# cuda-12.6
python -V	# Python 3.10.15
pip list	# torch 2.5.1+cu124, torchvision 0.20.1+cu124
```
## Commands

One simple example of the training command

```bash
nohup python SFedPO.py -m alexnetcifar -d cifar10 -R 100 -N 30 -M 60 -T 5 --optim sgd --lr 0.01 --global-lr 1.0 --batch-size 64 --seed 1234 --clip 0  --device 0 --save-model 0 --num-classes 10 --capacity 500 --method sfedpo --agg sfedpo --distance kl --a1 0.1 --b1 0.25 --a2 2.0 --b2 0.0 --oracle off --epsilon 0.01 &
```

Some arguments:

+ --capacity: data capacity.
+ --method: data sampling method, "sfedpo" means using DDS module.
+ --agg: aggregation strategy, "sfedpo" means using SAW module.
+ --alpha: sampling budget
+ --distance: the discrepancy metric.
+ --oracle: "off" means adding noise to the state probability.
+ --epsilon: the degree of perturbation.

One simple example of the data partitioning command

```
python sim/data/partition.py
```

Setups:

|         |Algorithm|  Fashion-MNIST   | CIFAR-10    | CINIC-10           |HAM10000   |
|---------|----------| --------------------------------- | ---------------- | ------------------- |------------------- |
|**Paper**|SFedPO,FedOGD,FedOMD,AdapFedAvg,FedDrift,Flash,FedEWC,FLwF-2T,IS,ODE,DRSR,FedAvg, FedProx, FedCurv, FedNTD, FedEXP| LeNet-5 | AlexNet     | AlexNet   |CNN    |
|**Code**|SFedPO,FedOGD,FedOMD,AdapFedAvg,FedDrift,Flash,FedEWC,FLwF,IS,ODE,DRSR,FedAvg, FedProx, FedCurv, FedNTD, FedEXP|lenet5| alexnetcifar | alexnetcifar |cnnham |
