import pandas as pd
import logging
import os

def prcolor(info, color='white'):
    ansi_code_color = {'red': 91, 'green': 92, 'yellow': 93, 'blue': 94, 'magenta': 95}
    if color in ansi_code_color.keys():
        print("\033[{}m{}\033[00m" .format(ansi_code_color[color], info))
    else:
        print(info)

def logconfig(path='./save/', name:str='', flag=''):
    if 'Log' in flag:
        filepath = path+'{}.log'.format(name)
        if (os.path.exists(filepath)):
            os.remove(filepath)
        logging.basicConfig(filename=filepath, level=logging.INFO)
    else:
        pass

def add_log(info:str='', color:str='white', flag:str=''):
    if 'Print' in flag:
        prcolor(info, color)
    if 'Log' in flag:
        logging.info(info)
    pass

def record_exp_result(filename, result):
    savepath = './save/'
    filepath = '{}/{}.csv'.format(savepath, filename)
    if result['round'] == 0:
        if (os.path.exists(filepath)):
            os.remove(filepath)
        with open (filepath, 'a+') as f:
            f.write('{},{},{},{},{},{},{}\n'.format('round', 
                                                    'train_loss', 'train_top1',  'train_top5', 
                                                    'test_loss',  'test_top1',   'test_top5'))
    else:
        with open (filepath, 'a+') as f:
            f.write('{},{:.4f},{:.4f},{:.4f},{:.4f},{:.4f},{:.4f}\n'
                    .format(result['round'],
                            result['train_loss'], result['train_top1'], result['train_top5'], 
                            result['test_loss'],  result['test_top1'],  result['test_top5']))

def record_exp_result2(filename, result):
    savepath = './save'
    filepath = '{}/{}.csv'.format(savepath, filename)
    if result['round'] == 0:
        if (os.path.exists(filepath)):
            os.remove(filepath)
        with open (filepath, 'a+') as f:
            f.write('{},{},{}\n'.format('round', 'test_loss',  'test_top1'))
    else:
        with open (filepath, 'a+') as f:
            f.write('{},{:.4f},{:.4f}\n'
                    .format(result['round'], result['test_loss'],  result['test_top1']))

    


