from abc import ABCMeta, abstractmethod

import torch


class IqBase(metaclass=ABCMeta):
    @abstractmethod
    def get_iq(self, information_quantity: torch.Tensor):
        pass

    def get_iq_estimate(self, information_quantity: torch.Tensor):
        return self.get_iq(information_quantity)


class Summarizer(metaclass=ABCMeta):
    @abstractmethod
    def reset(self):
        pass

    @abstractmethod
    def fit(self, latent_x_k_z, labels_x):
        pass


class EntropySummarizer(Summarizer, metaclass=ABCMeta):
    @abstractmethod
    def reset(self):
        pass

    @abstractmethod
    def fit(self, latent_x_k_z, labels_x):
        pass

    @abstractmethod
    def get_iq_base(self) -> IqBase:
        pass

    def get_iq(self, information_quantity: torch.Tensor):
        return self.get_iq_base().get_iq(information_quantity)
