import torch


class IsolatedModule(torch.nn.Module):
    """Does not propagate type or device conversions."""

    def __init__(self, dtype=None, device=None):
        super().__init__()

        self.dtype = dtype or torch.float32
        self.tdevice = device or torch.device("cpu")

    def convert_tensor(self, tensor: torch.Tensor, *, device_only=False, non_blocking=False):
        return tensor.to(device=self.tdevice, dtype=self.dtype if not device_only else None, non_blocking=non_blocking)

    def _apply(self, fn):
        return self

    def cuda(self, device=None):
        return self

    def cpu(self):
        return self

    def type(self, dst_type):
        return self

    def float(self):
        return self

    def double(self):
        return self

    def half(self):
        return self

    def share_memory(self):
        return self

    def to(self, *args, **kwargs):
        return self
