#!/bin/bash
set -e

# Run BERTSum on the set of texts generated by get_samples_bertsum.py

FILES="../hard-ans-samples-cnndm/*"
RESULTS="../results/hard-ans-cnndm/"
for f in $FILES
do
   id=${f#*e-}
   echo $id
   python train.py -mode test_text -result_path "$RESULTS$id" -task ext -test_from ../models/bertext_cnndm_transformer.pt -text_src "$f"
done

FILES="../easy-ans-samples-cnndm/*"
RESULTS="../results/easy-ans-cnndm/"
for f in $FILES
do
   id=${f#*e-}
   echo $id
   python train.py -mode test_text -result_path "$RESULTS$id" -task ext -test_from ../models/bertext_cnndm_transformer.pt -text_src "$f"
done
