#!/bin/bash
#SBATCH --job-name=ID_TO_REPLACEstu_tf
#SBATCH --output=zlogs/slurm.log
#SBATCH --error=zlogs/slurm.err
#SBATCH --gres=gpu:1
#SBATCH -N 1
#SBATCH -p rtx8000,v100
#SBATCH --mem=6000M
#SBATCH --time=0:11:00
#SBATCH --mail-type=ALL

source $HOME/.bashrc

mark=eu1h_gpt_gener677_b10_loadr833_1m_lrLR_TO_REPLACE_sample50_sac15_b20_ep0p05_eval1_rID_TO_REPLACE
#mark=eu1h_gpt_gener677_sample50_loadr833_1m_lrLR_TO_REPLACE_sac10_b10_ep0p015_eval2_rID_TO_REPLACE
lr=LR_TO_REPLACE

config_file=configs.student_tf_1h_ongpt_euro_clip
#config_file=configs.student_tf_1h_ongpt_euro
trained_teacher_model=outputs/euro6v001_182_t2k_bs32_r660_r820/0/model_best.ckpt
#loadmodel_for_student=outputs/eu001_182_prefix4_gpt_gene_4w_bs128_lr0p000001_r833/model_best.ckpt
loadmodel_for_student=outputs/eu001_182_prefix4_gpt_gene_4w_bs128_lr0p000001_r833/model_best.ckpt
#loadmodel_for_student=outputs/eu001_182_prefix4_gpt_gene_4w_bs256_lr0p0000003_r928/model_best.ckpt

output_path=outputs/$mark
log=logs/log$mark
err=logs/err$mark

mkdir -p $output_path

pythont=python

#CUDA_VISIBLE_DEVICES=${gpuid} \
$pythont gpt2_train.py \
  --do-train \
  --do-eval \
  --pretrained-model-name=gpt2-small \
  --trained_teacher_model=${trained_teacher_model} \
  --checkpoint ${loadmodel_for_student} \
  --lr ${lr} \
  --config-train=$config_file \
  --output-dir=$output_path  \
  > $log 2> $err
#  --checkpoint ${loadmodel_for_student} \
