# Contrastive-AIF - Contrastive Active Inference

This repository is the official implementation of Contrastive Active Inference.


## Dependencies

To install dependencies, please run:

`pip install -r requirements.txt`

Note: for the experiments on the Deep Mind Control Suite, you will need a licensed copy of Mujoco and to install the `dm_control` package.

## Train Code

To run experiments you can use one the following:

Minigrid:
```
python main.py --suite minigrid_pixels --task empty --config minigrid_empty_8x8 --algo contrastive_actinf --seed 34
```

Reacher:
```
python main.py --suite dmc --task reacher_easy_13 --config dmc_small dmc_benchmark --algo contrastive_actinf --seed 34
```


#### Paper Results

<img src="./plots/multiplot_minigrid.png" width="500">
</img></a>

<img src="./plots/multiplot_reacher.png" width="500">
</img></a>

### Acknowledgments

We would like to thank the authors of the following repositories for their open source code:

[Dreamer](https://github.com/danijar/dreamer) [TensorFlow implementation of Dreamer]
[dreamer-pytorch](https://github.com/juliusfrost/dreamer-pytorch) [PyTorch implementation of Dreamer]