# Out-of-distribution Detection with Diffusion-based Neighborhood

> Explore the potential of the DDIM-like models. :surfer::surfer::surfer: 

## Code structure

- **Model**: DDIM
- **Dataset**: Cifar10, Cifar100
- **Runner**:
  - runner: basic training and sampling
  - ood_detection: diffusion-based OOD detection

## How to run the code

### Dependencies
Run the following to install a subset of necessary python packages for our code.
```bash
pip install -r requirements.txt
```

### Usage
Train our models through main.py.
```bash
python main.py --runner base_train --config 32_cifar10_ood_cf.yml --train_path temp/train/base_multi
torchrun --nproc_per_node 2 main.py --runner train --config 32_cifar10_ood_cf.yml --train_path temp/train/base_multi
```
- runner: choose the mode of runner 
- device: choose the device to use
- config: choose the config file
- train_path: choose the path to save training status

Evaluate our models through main.py.
```bash
python main.py --runner base_fid --method DDIM --sample_speed 50 --device cuda --config 32_cifar10_ood_cf.yml \
  --image_path temp/results --model_path temp/models/ddim/ema_cifar10.ckpt
```
- method: choose the numerical methods
- sample_speed: control the total generation step
- image_path: choose the path to save images
- model_path: choose the path of model

Generate samples for OOD detection through main.py
```bash
python main.py --runner ood_itp --config 32_cifar10_ood_cf.yml --method DDIM --sample_speed 50 \
  --model_path temp/train/ema-140000.ckpt --model_name cifar10 --repeat_size 4
```
- model_name: choose the name for in-distribution datasets

Generate OOD detection results through detect.py
```bash
python detect/ood_detect.py --repeat_size 48 --id_name cifar100 --knn_type knn
```
- target: choose the name for in-distribution datasets
- speed: control the total generation step
- batch_size: choose the batch size
- repeat: choose the size of repeated sampling
- order: choose the order of the norm
