from overtraining.plotting.constants import EVAL_METADATA, FRIENDLY_CITATIONS
from overtraining.plotting.shared import *

df = EVAL_METADATA.drop(columns=["Description", "Centered Metric?"])

df = df.reset_index()  # make sure indexes pair with number of rows

final_rows = []
cols = [
    "Downstream task",
    "LLM-foundry category",
    "Evaluation type",
    "Number of shots",
    "Number of samples",
    "Random chance accuracy",
]
for index, row in df.iterrows():

    row = row.tolist()[1:]
    if row[0] in FRIENDLY_CITATIONS:
        final_rows.append(
            [
                FRIENDLY_CITATIONS[row[0]],
                row[1],
                row[2],
                str(row[3]),
                str(row[4]),
                f"{(row[5]/100):.2f}",
            ]
        )

final_rows = sorted(list(final_rows), key=lambda tup: tup[0])
print(make_latex_table(cols, final_rows, "None", "None", "None"))
print(len(final_rows))
