
# Read Me

# Fed MobiLLM: Efficient Federated LLM Fine-Tuning over Heterogeneous Mobile Devices via Server Assisted Side-Tuning


## Introduction

This folder contains part of the code implementation for the paper:

**_Fed MobiLLM: Efficient Federated LLM Fine-Tuning over Heterogeneous Mobile Devices via Server Assisted Side-Tuning_**

It includes two main components:

- **Device-side code** (`Device_backbone` folder)
- **Server-side code** (`Server_side` folder)

---

## How to Run

### 1. Open the Device-side Program Folder

Open the folder containing the device program. 

pip install -r requirements.txt

### 2. Configure the Socket Connection

Open the following two files:

- Device side: `sockconnet.py` (in the device folder)
- Server side: `server_side_network.py` (in the server folder)

Find the socket IP and port configuration section in both files. Modify the IP address and port number according to your network environment.

**Socket Configuration Example**


```python
#--------------device backbone--------------------
# host = input("IP address: ")
host = 'IP address'
port = xx # port num

s = socket.socket()
print(s)
s.connect((host, port))

#--------------server side network--------------------
host = 'IP address'
port = xx # port num
print(host)
s = socket.socket()
s.bind((host, port))
s.listen(5)
```

### 3. First, run the server program:

python server_side_network.py

### 4. Start the Device-side Program

python CAST_glue_device_backbone.py


### Once connected, the device will communicate with the server and start training in coordination.












