import torch

import acquire


class MaxEntropy(acquire.ConfidenceBased):

    NAME = "max-entropy"

    def score_zs(self, z_unlabelled, z_labelled):
        """Return a tensor of length z_unlabelled that represents each score."""
        return -(torch.exp(z_unlabelled) * z_unlabelled).sum(dim=1)