import numpy
import torch

import acquire


class Random(acquire.AcquisitionFn):

    NAME = "random"

    def acquire_unlabelled_indices(self, budget, unlabelled_datapool, labelled_datapool):
        """Return the budgeted number of indices pointing to the given unlabelled features.

        Parameters:
        ===========
        budget: int number of indices to acquire
        unlabelled_datapool: DataPool instance of unlabelled features.
        labelled_datapool: DataPool instance of labelled features.
        """
        all_i = numpy.array([i for i, _, _ in unlabelled_datapool])
        numpy.random.shuffle(all_i)
        return torch.from_numpy(all_i[:budget]).long()