import torch


class ResBlock(torch.nn.Module):

    def __init__(self, *layers, shortcut=None):
        """Instantiate a ResBlock object.

        Parameters:
        ===========
        *layers: torch.nn.Module layers of the resblock body.
        shortcut: Optional torch.nn.Module shortcut. Default None (identity).
        """
        super().__init__()
        self._body = torch.nn.Sequential(*layers)
        self._scut = shortcut or torch.nn.Sequential()

    def forward(self, X):
        return self._scut(X) + self._body(X)