import numpy
import sklearn.mixture


def create_copy_with_components(gmm, component_indices):
    assert gmm.covariance_type == "full"
    if type(indices) is list:
        indices = numpy.array(indices)

    new = sklearn.mixture.GaussianMixture(len(indices))

    new.means_ = gmm.means_[indices].copy()

    new_weights = gmm.weights_[indices].copy()
    new.weights_ = new_weights/new_weights.sum()

    new.covariances_ = gmm.covariances_[indices].copy()

    new.precisions_cholesky_ = gmm.precisions_cholesky_[indices].copy()
    return new