import logging
import os
import sys


def init(fpath):
    assert not os.path.isfile(fpath), fpath
    formatter = logging.Formatter(
        "[%(asctime)s] %(message)s",
        "%Y-%m-%d %H:%M:%S"
    )

    file_handler = logging.FileHandler(fpath, mode="w")
    file_handler.setFormatter(formatter)

    stream_handler = logging.StreamHandler(sys.stdout)
    stream_handler.setFormatter(formatter)

    logging.basicConfig(
        level=logging.INFO,
        handlers=[file_handler, stream_handler]
    )