import dataset
import utils


class DatapoolDisk(dataset.DatapoolCreator):

    def __init__(self, path, download, label_smooth):
        """Instantiate a DatapoolDisk object.

        Parameters:
        ===========
        path: str path to data on disk.
        download: bool whether to download the data to disk or not.
        """
        super().__init__(label_smooth)
        self._path = path
        self._download = download

        self._data = None
        self._test = None

    def get_full_testset(self):
        """Return a torch.utils.data.Dataset instance, the full test set.
        """
        self.get_full_dataset()
        self._test = self._test or self.load_testset_from_disk(
            self._path, self._download
        )
        return self._test

    # === PROTECTED ===

    def get_full_dataset(self):
        """Return a torch.utils.data.Dataset instance, the full dataset.
        """
        self._data = self._data or self.load_dataset_from_disk(
            self._path, self._download
        )
        return self._data

    @utils.abstract
    def load_dataset_from_disk(self, path, download):
        """Return torch.utils.data.Dataset instance, full dataset.

        Parameters:
        ===========
        path: str path to data on disk.
        download: bool whether to download the data to disk or not.
        """

    @utils.abstract
    def load_testset_from_disk(self, path, download):
        """Return a torch.utils.data.Dataset instance, the full test set.

        Parameters:
        ===========
        path: str path to data on disk.
        download: bool whether to download the data to disk or not.
        """