import tqdm


class Bar:

    NCOLS = 80
    DISABLE = False

    @staticmethod
    def config(ncols=80, disable=False):
        Bar.NCOLS = ncols
        Bar.DISABLE = disable

    def __init__(self, it, desc=None):
        self._it = it
        self._desc = desc
        self._bar = None

    def __enter__(self):
        self._bar = tqdm.tqdm(
            iterable=self._it, ncols=Bar.NCOLS, disable=Bar.DISABLE, desc=self._desc
        )
        return self._bar

    def __exit__(self, *args):
        self._bar.close()
