from .average import Average


class MovingAvg(Average):

    def __init__(self, alpha):
        self._alpha = alpha
        self._value = None

    def update(self, sum_values, n=1):
        self._value = sum_values/n
        self.update = self._update

    def _update(self, sum_values, n=1):
        self._value = (
            self._value * self._alpha
            +
            sum_values/n * (1-self._alpha)
        )

    def peek(self):
        return self._value