# Augmentation Component Analysis

## requirements

- attrs==21.2.0
- lightly==1.2.35
- matplotlib==3.4.2
- numpy==1.22.4
- pytorch_lightning==1.6.3
- torch==1.8.1
- torchvision==0.9.1
- tqdm==4.61.0

## scripts

### cifar10
> python main.py --model aca --lr 0.003 --gpus 1 \
 --max_epochs 800 --scheduler step --point 200 100 --val_every_n_epoch 4 --dataset cifar10 \
 --wd 1e-6 --optim adam --warmup --train_transform simclr --temperature 0.5 --lamb 1.0

### cifar100

> python main.py --model aca --lr 0.003 --gpus 0 \
 --max_epochs 8000 --scheduler step --point 200 100 --val_every_n_epoch 4 --dataset cifar100 \
 --wd 1e-6 --optim adam --warmup --train_transform simclr --temperature 0.5 --lamb 1.0

### stl10

> python main.py --model aca --lr 0.002 --gpus 0 --projection_output_dim 128 \
 --max_epochs 2000 --scheduler step --point 200 100 --val_every_n_epoch 4 --dataset stl10 \
 --wd 1e-6 --optim adam --warmup --train_transform simclr --temperature 0.5 --lamb 0.5

### tiny-imagenet

> python main.py --model aca --lr 0.002 --gpus 0 --projection_output_dim 128 \
 --max_epochs 1000 --scheduler step --point 200 100 --val_every_n_epoch 4 --dataset tiny-imagenet \
 --wd 1e-6 --optim adam --warmup --train_transform simclr --temperature 0.5 --lamb 0.1
