"""
This module contains prompt templates for generating structured reasoning traces.
"""

# Prompt template for structured reasoning with explicit pivots
STRUCTURED_REASONING_PROMPT = """This task requires solving problems using structured, real-time reasoning, including explicit self-monitoring and self-correction. Mimic the thought process of an agent that regularly pauses to reconsider assumptions, verify intermediate results, explore alternatives, and integrate findings into coherent solutions. Use explicit lexical pivots to signal shifts in thinking or corrections to your reasoning. Examples include:

**Realization pivots** (recognizing errors or oversights): "Wait—", "Oh—", "Actually -", "I missed something -".  

**Verification pivots** (explicitly testing assumptions or results): "Let me double-check -", "To verify—", "Checking again -".  

**Exploration pivots** (considering alternative approaches): "What if -", "Another way to look at this -", "Alternatively -".  

**Integration pivots** (synthesizing different ideas or resolving contradictions): "Now I see how -", "This connects back to -", "Putting this together -".

When solving the problem, follow a structured reasoning trace that clearly moves through the following stages:

1. **Problem Framing:** Restate the problem and identify key elements clearly.

2. **Exploration:** Consider one or more potential solution paths, openly weighing alternatives.

3. **Verification:** Explicitly test intermediate results or assumptions; if inconsistencies arise, pivot explicitly to clarify or correct.

4. **Synthesis:** Clearly integrate findings into a coherent solution, explicitly connecting back to the original problem.

Use direct, concise language. Short sentences should represent your evolving thoughts clearly. Use pivots naturally to signal shifts in reasoning, corrections, or deeper insights. Be explicit about confusion or uncertainty when it arises (e.g., "Something doesn't add up here," or "I'm not sure yet—").  

The goal is to clearly capture the structured yet flexible process of reasoning, highlighting non-linear thinking and self-correction, while making the logic easy to follow.

QUESTION: {question}

REASONING:
"""

# Prompt for generating incorrect but plausible answers
INCORRECT_ANSWER_PROMPT = """You are given a question and its correct answer. Your task is to modify the correct answer to create an incorrect but plausible alternative.

The incorrect answer should:
1. Be clearly wrong (not just an alternative correct formulation)
2. Be plausible enough that it could be mistaken for the correct answer
3. Follow the same format as the original answer
4. Ideally involve a small but critical error in reasoning

For mathematical problems, this might involve a sign error, forgetting to account for a constraint, or misinterpreting a concept.
For text problems, this might involve missing a key detail or making a logical error.

Original question: {question}
Correct answer: {answer}

Please provide an incorrect but plausible answer:
"""

# R1 reasoning prompt (simplified version to match R1's typical behavior)
R1_REASONING_PROMPT = """I want you to solve the following problem step-by-step, showing your reasoning process. Make sure to verify your work and correct any mistakes you find.

Question: {question}

Think through the problem carefully, and when you have determined your final answer, please present it using LaTeX format with \\boxed{{}} notation.
For example: \\boxed{{x=5}}

Let me think through this carefully.
""" 