"""
Utility functions for IO operations.
"""

import os
import json
import hashlib

def question_hash(question: str) -> str:
    """
    Generate a hash for a question.
    
    Args:
        question: The question text
        
    Returns:
        A hash string
    """
    return hashlib.md5(question.encode('utf-8')).hexdigest()

def jdump(obj, path):
    """
    Save object as JSON file.
    
    Args:
        obj: Object to save
        path: Path where to save the file
    """
    with open(path, 'w', encoding='utf-8') as f:
        json.dump(obj, f, ensure_ascii=False, indent=2)

def jload(path):
    """
    Load object from JSON file.
    
    Args:
        path: Path to the JSON file
        
    Returns:
        Loaded object
    """
    with open(path, 'r', encoding='utf-8') as f:
        return json.load(f) 