
Official PyTorch implementation of our paper for general continual learning (GCL).

Our proposed MePo (**Me**ta **Po**st-Pretraining) consists of the Meta-Learning for Representation Learning, Meta Covariance Initialization and the Feature Alignment in GCL to facilitate generalization of general continual learning, as presented in the following figure:


## How to run MePo?

### Build the conda environment

Please make sure that necessary packages in the environment.yml file are available.

### Three stages of MePo


#### Meta-Learning for Representation Learning

To post-pretraining the backbone parameters by our meta leaning strategy, please run:

    python ./metaViT4_rep_noW.py \
    -gpu_ids '0,1' \
    -inner_lr 0.1 \
    -num_tasks 50 \
    -model 'sup' \
    -epochs 50\
    -num_inner_steps 1 \
    -samples 200 &

The warmed-up prompts will be stored in the save_path.

#### Meta Covariance Initialization

To approximate the second-order statistics of pretrained representations, please see:

    meta_corvariance.ipynb


#### Training on downstram GCL training and test

To test different methods with different datasets, simply run the corresponding script with the specific dataset entry in the file:

    cd ./GCL

    CUDA_VISIBLE_DEVICES=1 . scripts/misa_cor1.sh


