# Precise Localization of Memories: A Fine-grained Neuron-level Knowledge Editing Technique for LLMs
This repository is the official implementation of the paper "Precise Localization of Memories: A Fine-grained Neuron-level Knowledge Editing Technique for LLMs".

Our code is based on [EasyEdit](https://github.com/zjunlp/EasyEdit) and [MM_Neurons](https://github.com/opanhw/MM_Neurons).

## Requirements

To get started, please install packages as:

```bash
conda create -n FINE python=3.9
...
pip install -r requirements.txt
```

## Benchmark

- KnowEdit Benchmark

See the benchmark details in [this page](https://huggingface.co/datasets/zjunlp/KnowEdit).

## Editing

Please setting parameters before editing. Parameters of FiNE can be found in `./hparams/FINE/`.

A sample editing command for gpt-j-6b is:

```bash
bash run_gptj_fine.sh
```

A sample editing command for llama-2-7b is:

```bash
bash run_llama2_fine.sh
```

A sample editing command for llama-3-8b is:

```bash
bash run_llama3_fine.sh
```

