## General
### Model
- `alg_name`: "SERAC"
- `archive`: /mnt/16t/yunzhi/EasyEdit/results/models/SERAC/llama2-7b-chat
- `device`: 0
- `model_name`: ../../hugging_cache/llama2-7b-chat
- `model_class`: LlamaForCausalLM
- `small_name`: ../../hugging_cache/llama-160m
- `tokenizer_class`: LlamaTokenizer
- `tokenizer_name`: ../../hugging_cache/llama2-7b-chat
- `cls_name`: ../../hugging_cache/distilbert-base-cased
- `cls_class`: AutoModel
- `inner_params`: []

### Method

- `alg`: SERAC
- `lr`: 1e-5
- `edit_lr`: 1e-2
- `seed`: 0
- `cedit`: 0.1
- `cloc`: 1.0
- `cbase`: 1.0 #used to calculate loss
- `dropout`: 0.0
- `final_eval`: True
- `supervised`: false
- `train_base`: False
- `no_grad_layers`: null
- `soft_weighting`: false
- `checkpoint_grad`: false
- `cross_attend`: false
- `cos`: false
- `freeze`: null
- `square`: true
- `bound_embeds`: false
- `use_all_negatives`: false
- `freeze_cntr`: false
- `dist_heads`: 1
- `lora`: null

- `batch_size`: 1
- `model_save_pt`: 500
- `edit_bs`: 1
- `silent`: False
- `max_iters`: 10000
- `log_interval`: 500
- `val_interval`: 500
- `early_stop_patience`: 40000
- `early_stop_key`: "loss/total_edit_val"
- `eval_only`: False
- `half`: False
- `save`: False
- `debug`: False
- `log_errors`: False
- `unlikelihood`: True
- `max_length`: 128

- `val_batch_size`: 1
- `accumulate_bs`: 10
- `val_steps`: 500
- `opt`: Adam
- `grad_clip`: 100.

### Output
- `results_dir`: ./results

## Multimodal
- `qformer_checkpoint`: Specifies the checkpoint file for QFormer used in the model. Example: `hugging_cache/blip2_pretrained_flant5xxl.pth`.

- `qformer_name_or_path`: Provides the name or path of the pre-trained QFormer model. This could be a name of a pre-trained model from the model hub or a local path to the model. Example: `bert-base-uncased` or `./local/path/to/model`.

- `state_dict_file`: Specifies the checkpoint file for the Vision Transformer (ViT) used as the vision encoder. Example: `hugging_cache/eva_vit_g.pth`.

### image
- `coco_image`:  The directory storing the COCO dataset. We can access specific images by appending the image path to this directory, like `coco_image + "val2014/COCO_val2014_000000451435.jpg"`.

- `rephrase_image`: The directory storing rephrase images generated by the diffusion model based on COCO. Specific images can be accessed by appending the image path to this directory, like `rephrase_image + "val2014_image_rephrase/451435003_COCO_val2014_000000451435.png"`.