from typing import Tuple
import logging
from pathlib import Path
import sys

PROJECT_ROOT_DIR = Path(__file__).parent.parent
if str(PROJECT_ROOT_DIR.absolute()) not in sys.path:
    sys.path.append(str(PROJECT_ROOT_DIR.absolute()))

from terminations.termination_base import TerminationBase

class TimeoutTermination(TerminationBase):
    def __init__(self, 
        termination_reward: float=-1.,
        env_config: dict=None,
        my_logger: logging.Logger=None
    ) -> None:
        super().__init__(
            termination_reward=termination_reward, 
            is_termination_reward_based_on_steps_left=False, 
            env_config=env_config, 
            my_logger=my_logger
        )

    def _get_termination(self, step_cnt: int) -> Tuple[bool, bool]:
        if step_cnt >= self.max_episode_steps - 1:
            return True, True

        return False, False

    def get_termination(self, state, **kwargs) -> Tuple[bool, bool]:
        assert "step_cnt" in kwargs, "args must include step_cnt"
        assert type(kwargs["step_cnt"]) is int, "step_cnt must be int"

        return self._get_termination(step_cnt=kwargs["step_cnt"])
    
    def get_termination_and_reward(self, state, **kwargs) -> Tuple[bool, bool, float]:
        assert "step_cnt" in kwargs, "args must include step_cnt"
        assert type(kwargs["step_cnt"]) is int, "step_cnt must be int"

        terminated, truncated = self._get_termination(step_cnt=kwargs["step_cnt"])
        
        return terminated, truncated, self.get_termination_penalty(terminated=terminated, steps_cnt=kwargs["step_cnt"])
        
    def reset(self):
        pass

    def __str__(self) -> str:
        return "timeout_termination"