import numpy as np
from typing import Tuple

def angle_of_2_3d_vectors(v1, v2):
    x = np.array(v1)
    y = np.array(v2)

    module_x = np.sqrt(x.dot(x))
    module_y = np.sqrt(y.dot(y))

    assert not np.any(np.allclose([module_x], [0.], atol=1e-8)), "the module of v1 is 0!"
    assert not np.any(np.allclose([module_y], [0.], atol=1e-8)), "the module of v2 is 0!"

    dot_value = x.dot(y)

    cos_theta = dot_value / (module_x * module_y)
    cos_theta = np.clip(cos_theta, a_min=-1.0, a_max=1.0)

    angle_radian = np.arccos(cos_theta)

    # angle_value = angle_radian * 180. / np.pi 
    angle_value = np.rad2deg(angle_radian)
    return angle_value

def angle_of_2_velocity(v_1: float, mu_1: float, chi_1: float, v_2: float, mu_2: float, chi_2: float):
    current_velocity_vector = [
        v_1 * np.cos(np.deg2rad(mu_1)) * np.sin(np.deg2rad(chi_1)), 
        v_1 * np.cos(np.deg2rad(mu_1)) * np.cos(np.deg2rad(chi_1)),
        v_1 * np.sin(np.deg2rad(mu_1)),
    ]
    target_velocity_vector = [
        v_2 * np.cos(np.deg2rad(mu_2)) * np.sin(np.deg2rad(chi_2)), 
        v_2 * np.cos(np.deg2rad(mu_2)) * np.cos(np.deg2rad(chi_2)),
        v_2 * np.sin(np.deg2rad(mu_2)),
    ]
    return angle_of_2_3d_vectors(current_velocity_vector, target_velocity_vector)

def angle_of_2_velocity2(ve_1: float, vn_1: float, vh_1: float, v_2: float, mu_2: float, chi_2: float):
    current_velocity_vector = [
        ve_1,
        vn_1,
        vh_1
    ]
    target_velocity_vector = [
        v_2 * np.cos(np.deg2rad(mu_2)) * np.sin(np.deg2rad(chi_2)), 
        v_2 * np.cos(np.deg2rad(mu_2)) * np.cos(np.deg2rad(chi_2)),
        v_2 * np.sin(np.deg2rad(mu_2)),
    ]
    return angle_of_2_3d_vectors(current_velocity_vector, target_velocity_vector)

def v_mu_chi_2_enh(v: float, mu: float, chi: float) -> Tuple[float, float, float]:
    mu_rad = np.deg2rad(mu)
    chi_rad = np.deg2rad(chi)
    return (
        v * np.cos(mu_rad) * np.sin(chi_rad),
        v * np.cos(mu_rad) * np.cos(chi_rad),
        v * np.sin(mu_rad)
    )