import logging
from pathlib import Path

PROJECT_ROOT_DIR = Path(__file__).parent.parent

def get_logger(logger_name:str="ucav", log_file_dir: Path=PROJECT_ROOT_DIR / "my_logs" / "my_sys_logs.log"):
    handler_file = logging.FileHandler(log_file_dir)  # stdout to file
    handler_control = logging.StreamHandler()    # stdout to console
    handler_file.setLevel('DEBUG')               # level: DEBUG 、INFO 、WARNING、ERROR、CRITICAL
    handler_control.setLevel('DEBUG')             

    selfdef_fmt = '%(asctime)s - %(funcName)s - %(levelname)s - %(message)s'
    formatter = logging.Formatter(selfdef_fmt)
    handler_file.setFormatter(formatter)
    handler_control.setFormatter(formatter)

    logger = logging.getLogger(logger_name)
    logger.setLevel('DEBUG')

    logger.addHandler(handler_file)
    logger.addHandler(handler_control)

    return logger



if __name__ == "__main__":
    my_logger = get_logger()
    my_logger.info('info')
    my_logger.warning('waring')
    my_logger.error('error')
    my_logger.critical('critical')