import torch
import matplotlib.pyplot as plt
import sys
import numpy as np
sys.path.append("../src")
from functions_to_generate import vanderpol_system

total_time = 40
time_step = 0.1
t, y = vanderpol_system(total_time, time_step, ic=torch.tensor([0, 1]))
fig, axes = plt.subplots(nrows=2)
axes[0].plot(y[0], label='x')
axes[1].plot(y[1], label='v')
plt.xlabel('Time')
plt.tight_layout()
plt.show()