#!/bin/bash

N_SEEDS=10 # N_SEEDS : number of seeds
N_EPOCHS_BASE=5000
FACTOR=5  # Fully-trained needs more epochs

DATADIR="../data/"
PARAMDIR="../params/"
RESULTDIR="../results/"

DIRNAME="vanderpol/"
PREDIR="${DATADIR}${DIRNAME}"

# Force-create the data directory
mkdir -p $PREDIR

# Force-create the param directory
mkdir -p "${PARAMDIR}${DIRNAME}"

# Copy simulation file to param directory
cp vanderpol_gen.py "${PARAMDIR}${DIRNAME}copy_vanderpol_gen_panelD.py"

# Loop
for DO_BIAS_LEARNING in 1 0
do
    for GAIN_REC in 1. 0.9
        do
            for (( i=1; i <= $N_SEEDS; i++ ))
              do
                N_EPOCHS=$(( N_EPOCHS_BASE+(1-DO_BIAS_LEARNING)*FACTOR*N_EPOCHS_BASE ))
                python vanderpol_gen.py --seed $i --resultdir "${RESULTDIR}${DIRNAME}" \
--datadir "${DATADIR}${DIRNAME}" --epochs $N_EPOCHS --bias_learning $DO_BIAS_LEARNING --gainrec $GAIN_REC
                echo
              done
        done
done

python ../analysis/vanderpol_sensitivity_to_gain.py --n_seeds $N_SEEDS
