# Feedforward results
This file contains the main code components used to generate figure 1 from the submitted (pre-rebuttal version) of the manuscript. Please contact the authors for code for the final version, or for any help getting this codebase running.

## Compute information
All experiments can be run on a single A100 GPU with 8G of RAM. Each experiment should not take more than 4h to run.

## Environment setup
Create a new virtual environment using `conda create -n bias_learning python=3.10`
Run `pip install -r requirements.txt`

Set the following environment variables:
- `export DATA_DIR=[where you want to store the data]`
- `export RESULTS_DIR=[where you want to store the results]`

## Figure 1.A

To reproduce the results from Figure 1.A
- Run `./figure1a.sh $DATA_DIR`

Note that this will not generate the plot but will print out the corresponding accuracies

## Figure 1.B

To reproduce the results from Figure 1.B:
- Run `./figure1b.sh $DATA_DIR $RESULTS_DIR`

Note again that this will not generate the plot but will print out the corresponding accuracies

## Figure 1.C
To reproduce the results from Figure 1.C:
- If you haven't already, run `./figure1b.sh $DATA_DIR $RESULTS_DIR`
- Run `./figure2a.sh $DATA_DIR $RESULTS_DIR`

The plot should now be at `$RESULTS_DIR/plots/fig2a.png`