import os
import sys
import torch
import matplotlib.pyplot as plt
import numpy as np
sys.path.append("../src")
from networks import AutoGenNet
from functions_to_generate import vanderpol_system


plt.style.use('../plot_params.dms')
units_convert = {'cm': 1 / 2.54, 'mm': 1 / 2.54 / 10}

result_folder = "../results/vanderpol"
data_folders = [f"../data/vanderpol/hiddensize675-lr0.1-biaslearningTrue-biasinituniform-epochs5000-gain1.0-gainout1.0-seed1",
                f"../data/vanderpol/hiddensize675-lr0.1-biaslearningTrue-biasinituniform-epochs5000-gain0.9-gainout1.0-seed1"]
network_size = (1, 675, 1)
models = [AutoGenNet(network_size=network_size), AutoGenNet(network_size=network_size )]
for i, model in enumerate(models):
    model.load_state_dict(torch.load(os.path.join(data_folders[i], 'model_weights.pth')))
    model.eval()

batch_size = 1
total_time = 15    # length of one episode
time_step = 0.1
t, y = vanderpol_system(total_time, time_step)
L = len(t)
x = torch.zeros((L, batch_size, network_size[0]),)
y = 2 * y[0]/ (y[0].max() - y[0].min()) - (y[0].max() + y[0].min()) / (y[0].max() - y[0].min())

preds = []
for model in models:
    with torch.no_grad():
        h0 = 0 * torch.rand((1, 1, network_size[1]))
        x = torch.zeros((L, 1, network_size[0]))
        p, h = model(x, h0)
        preds.append(p.squeeze())

plt.figure(figsize=(45*units_convert['mm'], 45/1.25*units_convert['mm']))
plt.plot(y, color='k', label='target')
for i, model in enumerate(models):
    plt.plot(preds[i], '--', lw=0.75, color='orange' if i==0 else (230/255, 97/255, 0), label='network | gain = 1.0' if i == 0 else 'network | gain = 0.9')
plt.xlabel('Time')
plt.ylabel('Output')
plt.legend(fontsize=5, labelspacing=0.25 )
plt.tight_layout()
plt.savefig(os.path.join(result_folder, 'Output_GainComparison_PanelC.png'))
plt.close()

