#!/bin/bash
N_EPOCHS=5000

DATADIR="../data/"
PARAMDIR="../params/"
RESULTDIR="../results/"

DIRNAME="vanderpol/"
PREDIR="${DATADIR}${DIRNAME}"

# Force-create the data directory
mkdir -p $PREDIR

# Force-create the param directory
mkdir -p "${PARAMDIR}${DIRNAME}"

# Copy simulation file to param directory
cp vanderpol_gen.py "${PARAMDIR}${DIRNAME}copy_vanderpol_gen_panelC.py"

# Loop over random initialization of the model
for GAIN_REC in 1. 0.9
  do
    python vanderpol_gen.py --seed 1 --resultdir "${RESULTDIR}${DIRNAME}" \
    --datadir "${DATADIR}${DIRNAME}" --epochs $N_EPOCHS --gainrec $GAIN_REC
  done

python ../analysis/vanderpol_loss.py
